package com.example.sefinsa_app.ui.rmd.Crear;

import android.text.InputFilter;
import android.text.Spanned;

public class DecimalDigitsInputFilter implements InputFilter {
    private final int maxDigitsBeforeDecimal;
    private final int maxDigitsAfterDecimal;

    public DecimalDigitsInputFilter(int maxDigitsBeforeDecimal, int maxDigitsAfterDecimal) {
        this.maxDigitsBeforeDecimal = maxDigitsBeforeDecimal;
        this.maxDigitsAfterDecimal = maxDigitsAfterDecimal;
    }

    @Override
    public CharSequence filter(CharSequence source, int start, int end,
                               Spanned dest, int dstart, int dend) {

        String newString = dest.toString().substring(0, dstart) + source + dest.toString().substring(dend);

        if (newString.equals(".")) return "0.";

        if (newString.contains(".")) {
            String[] parts = newString.split("\\.");

            if (parts.length > 2) return ""; // más de un punto

            // Validar parte entera
            if (parts[0].length() > maxDigitsBeforeDecimal) return "";

            // Validar parte decimal SOLO si existe
            if (parts.length == 2 && parts[1].length() > maxDigitsAfterDecimal) return "";

        } else {
            // Solo parte entera
            if (newString.length() > maxDigitsBeforeDecimal) return "";
        }

        return null;
    }

}
